# LDAP Benutzerattribute - Kurzreferenz

## Wichtige Benutzerattribute (inetOrgPerson)

| Attribut | Beschreibung | Beispiel |
|----------|--------------|----------|
| `uid` | Login-Name (eindeutig) | `mmustermann` |
| `cn` | Common Name (Vollständiger Name) | `Max Mustermann` |
| `sn` | Nachname (Pflicht!) | `Mustermann` |
| `givenName` | Vorname | `Max` |
| `displayName` | Anzeigename | `Max Mustermann` |
| `mail` | E-Mail-Adresse | `max@example.com` |
| `telephoneNumber` | Telefon (Büro) | `+49 123 456789` |
| `mobile` | Mobiltelefon | `+49 170 1234567` |
| `title` | Jobtitel | `Senior Developer` |
| `employeeNumber` | Personalnummer | `00042` |
| `employeeType` | Anstellungsart | `permanent`, `contractor`, `intern` |
| `departmentNumber` | Abteilungskürzel | `IT`, `HR`, `Finance` |
| `manager` | DN des Vorgesetzten | `uid=boss,ou=users,dc=...` |
| `o` | Organisation | `Example GmbH` |
| `ou` | Organisationseinheit | `IT` |
| `l` | Standort/Stadt | `Berlin` |
| `street` | Straße | `Musterstraße 1` |
| `postalCode` | PLZ | `10115` |
| `preferredLanguage` | Sprache | `de`, `en` |
| `userPassword` | Passwort (gehashed) | `{SSHA}...` |
| `description` | Beschreibung | Freitext |

## POSIX-Attribute (für Linux-Login)

| Attribut | Beschreibung | Beispiel |
|----------|--------------|----------|
| `uidNumber` | Numerische User-ID | `10001` |
| `gidNumber` | Primäre Gruppen-ID | `10000` |
| `homeDirectory` | Home-Verzeichnis | `/home/mmustermann` |
| `loginShell` | Login-Shell | `/bin/bash` |

## Gruppentypen

### groupOfNames (Standard)
- Mitglieder über `member`-Attribut (volle DNs)
- Mindestens 1 Member erforderlich
- Gut für Applikations-Berechtigungen

### posixGroup (Linux)
- Mitglieder über `memberUid` (nur uid, nicht DN)
- Hat `gidNumber`
- Für Linux/Unix-Systeme

## Typische Gruppenstruktur

```
ou=groups
├── cn=admins          # Vollzugriff
├── cn=it-support      # IT-Helpdesk
├── cn=developers      # Entwickler
├── cn=managers        # Führungskräfte
├── cn=employees       # Alle Mitarbeiter
├── cn=vpn-users       # VPN-Berechtigung
├── cn=rdp-users       # Remote-Desktop
├── cn=fileserver-read # Dateiserver lesen
└── cn=fileserver-write# Dateiserver schreiben
```

## Import-Befehl

```bash
# Ersetze dc=example,dc=com durch deine Base-DN
ldapadd -x -H ldap://192.168.0.14:389 \
  -D "cn=admin,dc=example,dc=com" \
  -W -f organization_schema.ldif
```

## Benutzer zur Gruppe hinzufügen

```ldif
dn: cn=developers,ou=groups,dc=example,dc=com
changetype: modify
add: member
member: uid=neueruser,ou=users,dc=example,dc=com
```

## Benutzer aus Gruppe entfernen

```ldif
dn: cn=developers,ou=groups,dc=example,dc=com
changetype: modify
delete: member
member: uid=alteruser,ou=users,dc=example,dc=com
```
